//
//  ViewController.m
//  TextUpdates
//
//  Created by Markus Möller on 10.05.13.
//  Copyright (c) 2013 Markus Möller. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()

@property (weak, nonatomic) IBOutlet UIView *messageView;
@property (weak, nonatomic) IBOutlet UILabel *messageLabel;

@property (strong, nonatomic) NSBundle *documentsBundle;

@end

@implementation ViewController


- (void)viewDidLoad {
    [super viewDidLoad];

    self.messageView.layer.cornerRadius = 10;

    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    self.documentsBundle = [NSBundle bundleWithPath:documentsDirectory];

    NSString *message = NSLocalizedStringWithDefaultValue(@"animatedText",
                                                       nil,
                                                       self.documentsBundle,
                                                       @"localized string not found",
                                                       nil);
    self.messageLabel.text = message;

    [UIView animateWithDuration:1 delay:0 options:UIViewAnimationOptionCurveEaseIn animations:^{ self.messageView.alpha = 0.8; } completion:^(BOOL finished){
        [UIView animateWithDuration:1 delay:3 options:UIViewAnimationOptionCurveEaseOut animations:^{ self.messageView.alpha = 0.0; } completion:^(BOOL finished) {
        }];
    }];


}

@end
